

function fea = normFea(fea, normtype, fea_Train_Mean)

%
% function fea = normFea(fea, normtype, fea_Train_Mean)
%
% Description:
%   Normalize feature vectors.
%
% IN:
%   fea: samples x features
%   fea_Train_Mean: mean feature vector
%   normtype: zeroMean, unityNorm, noNorm
%
% OUT:
%   fea: normed features
%
% Author: Nikolaos Gkalelis - CERTH-ITI
% Email: gkalelis@iti.gr
%
% First creation (Version 0.0) 1 Aug 2013.
% Version 0.1, 19 Jul 2017.
%

if sum(strcmp(normtype, {'zeroMean', 'unityNorm', 'noNorm'})) == 0
    error('Unknoun normalization type!!!');
end

if nargin < 3 && strcmp(normtype, 'zeroMean')
    error('Please provide mean feature vector!!!');
end
    
[noOfSamples, feaVecSize]= size(fea);

if strcmp(normtype,'zeroMean')
    fea = fea - repmat(fea_Train_Mean, noOfSamples,1);
elseif strcmp(normtype,'unityNorm')
    for n=1:noOfSamples
        fea(n,:) = fea(n,:) ./ max(eps, norm(fea(n,:)));
    end
elseif strcmp(normtype, 'noNorm')
    % do nothing
else
    error('normSortFea>> No normalization method is defined\n');
end