function ldS = regLogDet(S)

% 
% Compute the log determinant of matrix S. Input matrix S is regularized in
% case that it is ill-posed. Actual computation is done using logdet
% function.
%
%
% IN
%
% S: matrix - F x F
%
%
% OUT
%
% ldS: log determinant of matrix S - scalar
%
%
% Author: Nikolaos Gkalelis - CERTH-ITI
% Email: gkalelis@iti.gr
%
% Created 01 Aug 2013.
%

% fd = 1;
% fprintf(fd , 'regLogDet>> Entering\n');

ldS = logdet(S); % compute log determinant
   
% regularize in case that covariance matrix is ill-possed
EPS = realmin; EPSincr = 10;
iter = 0;
while isreal(ldS) == 0 || isinf(ldS) || isnan(ldS)
    iter = iter +1;
    S = S + eye(size(S))*EPS;
    ldS = logdet(S);
    EPS = EPS *(EPSincr);
    if rem(iter,200) == 0
        %fprintf(1, 'regLogDet>> iteration: %d\n', iter);
    end
end

% fprintf(fd , 'regLogDet>> Exiting\n');

