

function [ fea_sorted gnd_subclass_sorted Ni stopPartitioning] = incrementSubclassesOfClass( fea, P,  distType, Nmn)

% function [ fea_sorted gnd_subclass_sorted Ni stopPartitioning] = incrementSubclassesOfClass( fea, P,  distType, Nmn)
%
% Partition the input observations to P clusters
%
% IN
%
% fea: feature vector observations - N x F
%
% P: number of partitions to produce
%
% Nmn: minimum number of observations per partition
%
% distType: similarity (or disimilarity) measure to be used (Euclidean
% distance or cosine similarity)
%
% OUT
%
% fea_sorted: feature vectors sorted according to the ground truth cluster
% labels
%
% gnd_subclass_sorted: cluster ground truth sorted in increassing order
%
% Ni: number of observations per cluster
%
% stopPartitioning: cannot provide a new partition as minimum number of
% observations Nmn is reached
%
%
% Related references:
%
% 1. N. Gkalelis, V. Mezaris, I. Kompatsiaris, "Mixture subclass discriminant
% analysis", IEEE Signal Processing Letters, vol. 18, no. 5, pp. 319-322, 
% May 2011
%
% 2. N. Gkalelis, V. Mezaris, I. Kompatsiaris, T. Stathaki, "Mixture subclass 
% discriminant analysis link to restricted Gaussian model and other 
% generalizations", IEEE Transactions on Neural Networks and Learning 
% Systems, vol. 24, no. 1, pp. 8-21, January 2013.
%
%
% Author: Nikolaos Gkalelis - CERTH-ITI
% Email: gkalelis@iti.gr
%
% Created 01 Aug 2013.
%

%% partition to P clusters
[tmpLK, idx, Ni, stopPartitioning] = dbkmeans(fea', P, Nmn);
clear tmpLK;

%% check if minimum number of observations per partition is reached
if stopPartitioning == true
    fea_sorted = []; gnd_subclass_sorted = [];
    return;
end

%% sorting
fea_sorted = [];
gnd_subclass_sorted = [];
for i=1:P
	fea_sorted = [fea_sorted ; fea( idx == i,: )];
    gnd_subclass_sorted = [gnd_subclass_sorted ; i*ones( sum(idx == i), 1 )];
end


