

function [fea_sorted gnd_sorted] = sortFeaLabels(fea, gnd)

%
% Sort ground truth labels (and correspondingly feature vectors) in
% ascending order.
%
% IN
%
% fea: samples x features
% gnd: samples x 1
%
%
% OUT
%
% fea_sorted : sorted according to their labels
% gnd_sorted : 1 2 3 4 5 6 ....
%
%
% Author: Nikolaos Gkalelis - CERTH-ITI
% Email: gkalelis@iti.gr
%
% Created 01 Aug 2013.
%

classLbls = sort(unique(gnd));
numberOfClasses = length(classLbls);

fea_sorted = zeros(size(fea));
gnd_sorted = zeros(size(gnd));
b = 0;
for c=1:numberOfClasses
    a = b +1;
    b = sum(gnd == classLbls(c)) +b;
    fea_sorted(a:b, :) = fea(gnd == classLbls(c),:);
    gnd_sorted(a:b) = classLbls(c);
end

